﻿using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System;
using System.Linq;
using System.Printing;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace AZVIC.Ei8htPOS.POSRetail.Helper
{
    public static class DocumentHelper
    {
        #region Page Variables
        public static FontFamily fArial = new FontFamily("Arial");
        public static FontWeight fWeight = FontWeight.FromOpenTypeWeight(600);
        public static Brush brdBrush = Brushes.Black;
        public static Thickness brdThickness = new Thickness(0.5);
        #endregion

        public static void GenerateDocument(Orders _Orders)
        {
            Orders currOrder = _Orders;
            OrdersDetails odet = (from od in currOrder.OrdersDetailsList
                                  select od).FirstOrDefault<OrdersDetails>();
            FlowDocument document = new FlowDocument();

            document.PageHeight = 850;
            document.PageWidth = 750;
            document.PagePadding = new Thickness(100, 20, 20, 20);

            #region Logo and Address Section
            document.Blocks.Add(AddHeader());
            #endregion

            #region Invoice Title Section
            Table TitleTable = new Table();
            TitleTable.Columns.Add(new TableColumn());
            TableRow TitleTextRow = new TableRow();
            TitleTextRow.Cells.Add(new TableCell(new Paragraph(new Run("\n\nTAX INVOICE\n"))));
            TitleTextRow.Cells[0].FontFamily = fArial;
            TitleTextRow.Cells[0].FontSize = 12;
            TitleTextRow.Cells[0].FontWeight = fWeight;
            TitleTextRow.Cells[0].TextAlignment = TextAlignment.Center;

            TableRow GSTRow = new TableRow();
            GSTRow.Cells.Add(new TableCell(new Paragraph(new Run("GST No. 53191999D\n\n"))));
            GSTRow.Cells[0].FontFamily = fArial;
            GSTRow.Cells[0].FontSize = 10;
            GSTRow.Cells[0].FontWeight = fWeight;
            GSTRow.Cells[0].TextAlignment = TextAlignment.Center;

            TableRowGroup trg = new TableRowGroup();
            trg.Rows.Add(TitleTextRow);
            trg.Rows.Add(GSTRow);
            TitleTable.RowGroups.Add(new TableRowGroup());
            TitleTable.RowGroups[0] = trg;

            document.Blocks.Add(TitleTable);
            #endregion

            #region Billing Info Section
            Table ShipInfoTable = new Table();
            ShipInfoTable.CellSpacing = 0;
            for (int i1 = 0; i1 < 2; i1++)
            {
                ShipInfoTable.Columns.Add(new TableColumn());
            }
            ShipInfoTable.BorderBrush = brdBrush;
            ShipInfoTable.BorderThickness = new Thickness(0.5);


            TableRow TitleRow = new TableRow();
            TitleRow.FontFamily = fArial;
            TitleRow.FontSize = 12;
            TitleRow.FontWeight = fWeight;

            TitleRow.Cells.Add(new TableCell(new Paragraph(new Run("BILL TO"))));

            TitleRow.Cells.Add(new TableCell(new Paragraph(new Run("DELIVER TO"))));

            TitleRow.Cells.Add(new TableCell(new Paragraph(new Run("INVOICE"))));

            foreach (TableCell tc in TitleRow.Cells)
            {
                tc.BorderBrush = brdBrush;
                tc.TextAlignment = TextAlignment.Left;
                tc.BorderThickness = new Thickness(0, 0, 0.5, 0);
                tc.Padding = new Thickness(5);
            }
            TitleRow.Cells[2].BorderThickness = new Thickness(0);


            TableRow ContentRow = new TableRow();
            ContentRow.FontFamily = fArial;
            ContentRow.FontSize = 10;
            ContentRow.FontWeight = FontWeight.FromOpenTypeWeight(300);
            ContentRow.Cells.Add(new TableCell(new Paragraph(new Run(string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                            string.Format("{0}{1}\n", currOrder.BillingAddress1, string.IsNullOrEmpty(currOrder.BillingAddress2) ? string.Empty : "\n" + currOrder.BillingAddress2) +
                                           string.Format("{0}\n{1}\n", currOrder.BillingCity, currOrder.BillingState) +
                                           string.Format("{0} - {1}\n", currOrder.BillingCountry, currOrder.BillingPostalCode) +
                                           string.Format("Mobile: {0}", currOrder.BillingMobile)))));
            ContentRow.Cells[0].BorderBrush = brdBrush;
            ContentRow.Cells[0].BorderThickness = new Thickness(0, 0, 0.5, 0);
            ContentRow.Cells[0].Padding = new Thickness(5);
            ContentRow.Cells.Add(new TableCell(new Paragraph(new Run(string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                                           string.Format("{0}{1}\n", currOrder.ShippingAddress1, string.IsNullOrEmpty(currOrder.ShippingAddress2) ? string.Empty : "\n" + currOrder.ShippingAddress2) +
                                           string.Format("{0}\n{1}\n", currOrder.ShippingCity, currOrder.ShippingState) +
                                           string.Format("{0} - {1}\n", currOrder.ShippingCountry, currOrder.ShippingPostalCode) +
                                           string.Format("Mobile: {0}", currOrder.ShippingMobile)))));
            ContentRow.Cells[1].BorderBrush = brdBrush;
            ContentRow.Cells[1].BorderThickness = new Thickness(0, 0, 0.5, 0);
            ContentRow.Cells[1].Padding = new Thickness(5);
            ContentRow.Cells.Add(new TableCell(new Paragraph(new Run(string.Format("INVOICE NO: {0}\n", currOrder.InvoiceNo) +
                                    string.Format("Order Date: {0}\n", currOrder.CreatedDate.ToString("dd/MM/yyyy")) +
                                    string.Format("Payment Method: {0}\n", currOrder.PaymentMethod) +
                                    string.Format("Sales Order No: {0}\n", currOrder.OrderNumber) +
                                    string.Format("Sales Order Date: {0}\n", currOrder.CreatedDate.ToString("dd/MM/yyyy")))) { LineHeight = 15 }));
            ContentRow.Cells[2].Padding = new Thickness(5);
            ShipInfoTable.RowGroups.Add(new TableRowGroup());
            ShipInfoTable.RowGroups[0].Rows.Add(TitleRow);
            ShipInfoTable.RowGroups[0].Rows.Add(ContentRow);

            document.Blocks.Add(ShipInfoTable);
            #endregion

            #region Item Details

            int Pagesize = 15;
            int Threshold = 7;
            bool isLastPage = false, applyPageBreak = false;
            int OrderCount = currOrder.OrdersDetailsList.Count;
            int NoOfPages = OrderCount / Pagesize;
            Table TotalTable = new Table();
            TotalTable.CellSpacing = 0;
            for (int page = 0; page <= NoOfPages; page++)
            {
                Table ItemDetails = new Table();
                ItemDetails.CellSpacing = 0;
                Table LogoHeader = new Table();

                isLastPage = page == NoOfPages ? true : false;


                if (isLastPage)
                {
                    //Merge with Item Details
                    if (OrderCount - (page * Pagesize) <= Threshold)
                    {
                        applyPageBreak = true;
                    }
                    else
                    {
                        applyPageBreak = false;
                    }
                }

                //If Last Page has more than the threshold, Initiate a new page
                if ((page > 0))
                {
                    document.Blocks.Add(AddPageBreak(50));
                    LogoHeader = AddHeader();
                    document.Blocks.Add(LogoHeader);
                    //Only if some elements are left to be printed, Add Header - Otherwise ignore it 
                    if (OrderCount - (page * Pagesize) <= 0)
                    {
                        applyPageBreak = false;
                    }
                }

                ItemDetails.RowGroups.Add(new TableRowGroup());
                if (OrderCount - (page * Pagesize) > 0)
                {
                    ItemDetails.RowGroups[0].Rows.Add(AddItemTableHeader());
                }


                for (int order = 0; order < Pagesize; order++)
                {
                    int currOrderNo = page * Pagesize + order;
                    int slNo = currOrderNo + 1;
                    if (currOrderNo >= currOrder.OrdersDetailsList.Count)
                    {
                        break;
                    }
                    TableRow Items = new TableRow();
                    ItemDetails.Columns.Add(new TableColumn() { Width = new GridLength(68) });
                    ItemDetails.Columns.Add(new TableColumn() { Width = new GridLength(310) });
                    ItemDetails.Columns.Add(new TableColumn() { Width = new GridLength(70) });
                    ItemDetails.Columns.Add(new TableColumn() { Width = new GridLength(90) });
                    ItemDetails.Columns.Add(new TableColumn() { Width = new GridLength(90) });

                    Items.FontFamily = fArial;
                    Items.FontSize = 10;

                    Items.Cells.Add(new TableCell(new Paragraph(new Run(slNo++.ToString()))));
                    Items.Cells[0].TextAlignment = TextAlignment.Center;
                    Items.Cells[0].Padding = new Thickness(2);
                    Items.Cells.Add(new TableCell(new Paragraph(new Run(currOrder.OrdersDetailsList[currOrderNo].ProductName))));
                    Items.Cells[1].TextAlignment = TextAlignment.Left;
                    Items.Cells[1].Padding = new Thickness(2);
                    Items.Cells.Add(new TableCell(new Paragraph(new Run(currOrder.OrdersDetailsList[currOrderNo].Quantity.ToString()))));
                    Items.Cells[2].TextAlignment = TextAlignment.Center;
                    Items.Cells[2].Padding = new Thickness(2);
                    Items.Cells.Add(new TableCell(new Paragraph(new Run(currOrder.OrdersDetailsList[currOrderNo].OrderPrice.ToString("0.00")))));
                    Items.Cells[3].TextAlignment = TextAlignment.Center;
                    Items.Cells[3].Padding = new Thickness(2);
                    Items.Cells.Add(new TableCell(new Paragraph(new Run(currOrder.OrdersDetailsList[currOrderNo].Amount.ToString("0.00")))));
                    Items.Cells[4].TextAlignment = TextAlignment.Right;
                    Items.Cells[4].Padding = new Thickness(2);

                    for (int i = 0; i < 5; i++)
                    {
                        Items.Cells[i].BorderBrush = brdBrush;
                        Items.Cells[i].BorderThickness = new Thickness(0, 0.5, 0.5, 0);
                    }
                    Items.Cells[0].BorderThickness = new Thickness(0.5, 0.5, 0.5, 0);

                    ItemDetails.RowGroups[0].Rows.Add(Items);
                }
                if (ItemDetails.RowGroups[0].Rows.Count >= 1)
                {
                    ItemDetails.RowGroups[0].Rows[ItemDetails.RowGroups[0].Rows.Count - 1].Cells.ToList().ForEach(a => a.BorderThickness = new Thickness(0, 0.5, 0.5, 0.5));
                    ItemDetails.RowGroups[0].Rows[ItemDetails.RowGroups[0].Rows.Count - 1].Cells[0].BorderThickness = new Thickness(0.5, 0.5, 0.5, 0.5);
                    ItemDetails.RowGroups[0].Rows[ItemDetails.RowGroups[0].Rows.Count - 1].Cells[4].BorderThickness = new Thickness(0, 0.5, 0.5, 0.5);
                }
                document.Blocks.Add(ItemDetails);
                if ((page > 0))
                {
                    document.Blocks.Add(AddPageBreak(50));
                }

            }
            #endregion

            #region Totals

            TableRow Totals = new TableRow();
            Totals.FontFamily = fArial;
            Totals.FontSize = 10;

            Totals.Cells.Add(new TableCell(new Paragraph(new Run("Sub Total:\nDiscount:\nShipping\nTotal Before GST:\nGST\nGrand Total:\nPayment:\nAmount Payable:\n"))));
            Totals.Cells[0].ColumnSpan = 3;
            Totals.Cells[0].TextAlignment = TextAlignment.Right;

            Totals.Cells.Add(new TableCell(new Paragraph(new Run("SGD\nSGD\nSGD\nSGD\nSGD\nSGD\nSGD\nSGD\n"))));
            Totals.Cells[1].TextAlignment = TextAlignment.Right;

            Totals.Cells.Add(new TableCell(new Paragraph(new Run(string.Format("{0}\n", currOrder.SubTotal.ToString("0.00")) +
            string.Format("{0}\n", currOrder.Discount.ToString("0.00")) +
            string.Format("{0}\n", currOrder.Shipping.ToString("0.00")) +
            string.Format("{0}\n", currOrder.TotalBeforeGST.ToString("0.00")) +
            string.Format("{0}\n", currOrder.GST.ToString("0.00")) +
            string.Format("{0}\n", currOrder.Total.ToString("0.00")) +
            string.Format("{0}\n", currOrder.PaidAmount.ToString("0.00")) +
            string.Format("{0}\n", ((currOrder.Total - currOrder.PaidAmount) >= 0 ? (currOrder.Total - currOrder.PaidAmount) : 0).ToString("0.00"))))));
            Totals.Cells[2].TextAlignment = TextAlignment.Right;
            Totals.Cells[0].BorderBrush = Totals.Cells[1].BorderBrush = Totals.Cells[2].BorderBrush = brdBrush;
            Totals.Cells.ToList().ForEach(a => a.Padding = new Thickness(2));
            if (applyPageBreak)
            {

                Totals.Cells[0].BorderThickness = new Thickness(0.5, 0, .5, .5);
                Totals.Cells[1].BorderThickness = new Thickness(0, 0, .5, .5);
                Totals.Cells[2].BorderThickness = new Thickness(0, 0, .5, .5);

                //Merge the Totals with Existing Table
                Table td = document.Blocks.LastBlock as Table;
                td.RowGroups[0].Rows.Add(Totals);
            }
            else
            {
                //Add it as Seperate Table
                Totals.Cells[0].BorderThickness = new Thickness(0.5);
                Totals.Cells[1].BorderThickness = new Thickness(0, 0.5, 0, 0.5);
                Totals.Cells[2].BorderThickness = new Thickness(0.5);
                TotalTable.RowGroups.Add(new TableRowGroup());
                TotalTable.RowGroups[0].Rows.Add(Totals);
                TotalTable.BreakColumnBefore = true;
                int RowHeight = (OrderCount % Pagesize) > 12 ? 100 : 150;
                RowHeight = (OrderCount % Pagesize) == 0 ? 10 : RowHeight;
                document.Blocks.Add(AddPageBreak(RowHeight));
                if ((OrderCount % Pagesize) > Threshold)
                {
                    document.Blocks.Add(AddHeader());
                }
                document.Blocks.Add(TotalTable);
            }
            #endregion

            Table FooterTable = new Table();
            FooterTable.FontSize = 10;
            FooterTable.FontFamily = fArial;
            FooterTable.FontWeight = fWeight;

            TableRow AuthoriseTable = new TableRow();
            AuthoriseTable.Cells.Add(new TableCell(new Paragraph(new Run("\n\nAcknowledge By Customer:\n\n\n\n_______________________________\nSignature / Stamp\nDate:\t\t\t\t\t"))));
            AuthoriseTable.Cells[0].TextAlignment = TextAlignment.Right;
            AuthoriseTable.Cells[0].FontWeight = fWeight;

            TableRow Disclaimer = new TableRow();
            Disclaimer.Cells.Add(new TableCell(new Paragraph(new Run("\n\nThis is a computer generated document and requires no signature.\n\n"))));
            Disclaimer.Cells[0].TextAlignment = TextAlignment.Left;

            FooterTable.RowGroups.Add(new TableRowGroup());
            FooterTable.RowGroups[0].Rows.Add(AuthoriseTable);
            FooterTable.RowGroups[0].Rows.Add(Disclaimer);

            document.Blocks.Add(FooterTable);

            //Testing Layout
            //foreach (Block bk in document.Blocks)
            //{
            //    bk.BorderBrush = brdBrush;
            //    bk.BorderThickness = brdThickness;
            //}
            while (AppSession.CheckPrinterAssigned())
            {
                #region Printing the Flow Document
                PrintDialog pd = new PrintDialog();
                IDocumentPaginatorSource idocument = document as IDocumentPaginatorSource;

                if (Properties.Settings.Default.InvoicePrinter.Contains(@"\\"))
                {
                    EnumeratedPrintQueueTypes[] enumerationFlags = { EnumeratedPrintQueueTypes.Connections, EnumeratedPrintQueueTypes.Local, EnumeratedPrintQueueTypes.Shared, EnumeratedPrintQueueTypes.TerminalServer };
                    LocalPrintServer printServer = new LocalPrintServer();
                    PrintQueueCollection printQueuesOnLocalServer = printServer.GetPrintQueues(enumerationFlags);
                    pd.PrintQueue = printQueuesOnLocalServer.Where(x => x.FullName == Properties.Settings.Default.InvoicePrinter).FirstOrDefault();
                }
                else
                {
                    pd.PrintQueue = new LocalPrintServer().GetPrintQueue(Properties.Settings.Default.InvoicePrinter);
                }

                pd.PrintDocument(idocument.DocumentPaginator, "Printing Invoice");
                #endregion
                break;
            }
        }

        private static Table AddHeader()
        {
            Table HeaderTable = new Table();
            for (int i = 0; i < 2; i++)
            {
                HeaderTable.Columns.Add(new TableColumn());
            }
            TableRow imgRow = new TableRow();
            //Add Logo
            Image imgControl = new Image();
            BitmapImage Logo = new BitmapImage(new Uri("pack://application:,,,/Resources/Images/Logo.jpg", UriKind.Absolute));
            imgControl.Source = Logo;
            imgControl.Height = 100;
            imgControl.Width = 125;
            imgControl.HorizontalAlignment = HorizontalAlignment.Left;
            imgRow.Cells.Add(new TableCell(new BlockUIContainer(imgControl)));
            //Add Empty space 
            imgRow.Cells.Add(new TableCell());
            imgRow.Cells[0].TextAlignment = TextAlignment.Left;

            imgRow.Cells.Add(new TableCell(new Paragraph(new Run("371 Beach Road\n#03-10 Keypoint\nSingapore 199597\nReg.No. 53191999D\nTel: (65)  6636 8819\nFax: (65) 6725 0966\nEmail: sales@azvic.com.sg\nWebsite: www.ei8htpos.com.sg"))));
            imgRow.Cells[2].FontFamily = fArial;
            imgRow.Cells[2].TextAlignment = TextAlignment.Right;
            imgRow.Cells[2].FontSize = 9;
            imgRow.Cells[2].FontWeight = fWeight;
            HeaderTable.RowGroups.Add(new TableRowGroup());
            HeaderTable.RowGroups[0].Rows.Add(imgRow);
            return HeaderTable;
        }

        private static TableRow AddItemTableHeader()
        {
            TableRow ItemDetailHeader = new TableRow();
            ItemDetailHeader.FontFamily = new FontFamily("Arial");
            ItemDetailHeader.FontSize = 10;
            ItemDetailHeader.FontWeight = FontWeight.FromOpenTypeWeight(600);
            Brush brdBrush = Brushes.Black;

            ItemDetailHeader.Cells.Add(new TableCell(new Paragraph(new Run("Sl.No"))));

            ItemDetailHeader.Cells.Add(new TableCell(new Paragraph(new Run("Item Descriptions"))));

            ItemDetailHeader.Cells.Add(new TableCell(new Paragraph(new Run("Qty"))));

            ItemDetailHeader.Cells.Add(new TableCell(new Paragraph(new Run("Unit Price"))));

            ItemDetailHeader.Cells.Add(new TableCell(new Paragraph(new Run("Amount"))));

            for (int i = 0; i < 5; i++)
            {
                ItemDetailHeader.Cells[i].BorderBrush = brdBrush;
                ItemDetailHeader.Cells[i].BorderThickness = new Thickness(0, 0.5, 0.5, 0);
                ItemDetailHeader.Cells[i].TextAlignment = TextAlignment.Center;
                ItemDetailHeader.Cells[i].Padding = new Thickness(2);
            }
            ItemDetailHeader.Cells[0].BorderThickness = new Thickness(0.5, 0.5, 0.5, 0);

            return ItemDetailHeader;
        }

        private static Table AddPageBreak(int RowsToDisplay)
        {
            Table EmptyRow = new Table() { LineHeight = RowsToDisplay };
            EmptyRow.RowGroups.Add(new TableRowGroup());
            EmptyRow.RowGroups[0].Rows.Add(new TableRow());
            EmptyRow.RowGroups[0].Rows.Add(new TableRow());
            EmptyRow.RowGroups[0].Rows.Add(new TableRow());
            EmptyRow.RowGroups[0].Rows.Add(new TableRow());
            return EmptyRow;
        }

    }
}
